<?php
namespace app\em\model;

class Useage extends Base
{
    protected $table = 'em_useage';

    public function getLastDateAttr($val){
        return date('Y-m-d',$val);
    }
    public function setLastDateAttr($val){
        return strtotime($val);
    }

    public function getCurrentDateAttr($val){
        return date('Y-m-d',$val);
    }
    public function setCurrentDateAttr($val){
        return strtotime($val);
    }

    //首页列表
    public function getList($page = 0){
        $config = !empty($config) ?: [
            'list_rows'=>30,
            'page'=> $page,
            'type'     => '\app\extend\PageLayUi',
            'var_page' => 'page'
        ];
        $data = self::alias('ue')
                    ->field('ue.*')
                    ->field('station.station_name')
                    ->field('em.em_numb')
                    ->leftJoin(['em'],'em.id=ue.em_id')
                    ->leftJoin(['station_info'=>'station'],'station.station_id=em.station_id')
                    ->paginate($config);
        return $data;
    }
   //首页列表+search
    public function getCopyList($map,$Nowpage,$limits){

        $data = self::alias('ue')
            ->field('ue.*')
            ->field('station.station_name')
            ->field('em.em_numb')
            ->leftJoin(['em'],'em.id=ue.em_id')
            ->leftJoin(['station_info'=>'station'],'station.station_id=em.station_id')
            ->where($map)
            ->page($Nowpage, $limits)
            ->order('ue.id desc')
            ->select()
            ->toarray();
        return $data;
    }
    public function getCopyListCount($map){
        $data = self::alias('ue')
            ->field('ue.*')
            ->field('station.station_name')
            ->field('em.em_numb')
            ->leftJoin(['em'],'em.id=ue.em_id')
            ->leftJoin(['station_info'=>'station'],'station.station_id=em.station_id')
            ->where($map)
            ->count();
        return $data;
    }
    //获取抄表单列表,并组合电表信息与电表规则信息
    public function getListUseageInfo(){
        $data = self::alias('ue')
            ->field('*')
            ->field('em.em_numb,em.em_type_id,em.rate')
            ->field('er.charge_type,er.pay_price,
                er.cycle_start_time,er.cycle_amount,er.cycle_finish_time,
                er.settle_price,er.settle_type,er.pricing_type
                ')
            ->leftJoin(['em'],'em.id=ue.em_id')
            ->leftJoin(['em_rule'=>'er'],'er.em_id=em.id')
            ->where('ue.status=1 and ue.photo_id!=""')
            ->select()
            ->toArray();
        return $data;
    }

    public function getEmInfoByUseageId($useage_id){
        $data = self::alias('ue')
            ->field('*')
            ->field('em.em_numb,em.em_type_id,em.rate')
            ->field('er.charge_type,er.pay_price,
                er.cycle_start_time,er.cycle_amount,er.cycle_finish_time,
                er.settle_price,er.settle_type,er.pricing_type
                ')
            ->leftJoin(['em'],'em.id=ue.em_id')
            ->leftJoin(['em_rule'=>'er'],'er.em_id=em.id')
            ->where('ue.status=1 and ue.photo_id!=""')
            ->where(['useage_id'=>$useage_id])
            ->find();
        return $data;
    }

    public function photo(){
        return $this->belongsTo('Receipt','photo_id','id');
    }

    public function em(){
        return $this->belongsTo('Em','em_id','id');
    }
}