<?php
namespace app\admin\validate;
use think\Validate;

class SettleAddValidate extends Validate
{
    protected $rule = [
        'cp_id'=>'require',
        'client'=>'require',
        'amount'=>'require',
        'settle_date' =>'require',
        'invoice_numb' => 'require',
        'invoice_fid' => 'require',
        'settle_sid' => 'require',
    ];

    protected $message = [
        'cp_id.require' => '系统错误,为找到关联的抄表单ID,请联系管理员',
        'client.require' => '请选择客户',
        'amount.require' => '请填写结算金额',
        'settle_date.require' => '结算日期必填',


        'invoice_numb.require' => '请填写发票号',
        'invoice_fid.require' => '请上传发票附件',
        'settle_pay_sid.require' => '请选择结算人',
    ];

    protected $scene = [
        'staff' => 'cp_id,client,amount,settle_date',
        'finance' => 'invoice_numb,invoice_fid,settle_sid'
    ];
}