<?php
namespace app\admin\validate;
use think\Validate;

class EmAddValidate extends Validate
{
    protected $rule = [
        'station_id' => 'require',              //station_id,electric_type,electric_number,pay_number,multiple,init_degree,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel
        'electric_type' => 'require',
        'electric_number' =>'require',
        'pay_number'=> 'require',
        'multiple' => 'require|max:6',
        'init_degree' => 'require',
        'init_amount' => 'require',
        'first_cp_date' => 'require',
        'unit_price' => 'require',
        'pay_cycle'=> 'require|max:2',        //room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period
        'staff_id' => 'require',
        'address' => 'require',
        'photo_id' => 'require',
        'contact' => 'require',
        'contact_tel' => 'require',
        'room_position'=>'require',
        'property_position'=>'require',
        'receive' => 'require',
        'rent' => 'require',
        'engineroom_remark' => 'max:255',
        'contract_number' => 'require',
        'contract_confirm_date' => 'require',
        'period' => 'require|max:3',
        'protocol_id' => 'require'

    ];

    protected $message = [
        'station_id.require' => '请选择基站',
        'electric_type.require' => '请选择电表类型',
        'electric_number.require' => '请填写电表识别号',
        'pay_number.require' => '请填写缴费号',
        'multiple.require' => '请填写倍率',
        'multiple.integer' => '倍率只能填写正整数',
        'multiple.max' => '倍率值不合法',
        'init_degree.require' => '请填写初始读数',
        'init_amount.require' => '请填写初始读数',
        'first_cp_date.require' => '请填写首次查表日期',
        'unit_price.require' => '请填写抄表单单价',
        'pay_cycle.require' => '请填写缴费周期',
        'pay_cycle.max' => '缴费周期不能大于两位数',
        'staff_id.require' => '请选择业务员',
        'address.require' => '请填写电表地址',
        'photo_id.require' => '请上传电表照片',
        'contact.require' => '请填写机房联系人',
        'contact_tel.require' => '请填写机房联系人',
        'room_position.require' => '请填写机房位置',
        'property_position.require' => '请填写物业位置',
        'receive.require' => '请填写实际收款单位',
        'rent.require' => '请填写出租单位信息',
        'engineroom_remark.max' => '机房备注信息不能超过80个汉字',
        'contract_number.require' => '请填写合同信息',
        'contract_confirm_date.require' => '请填写合确认日期',
        //'contract_confirm_date.dateFormat' => '合同日期格式只能是年-月-日',
        'period.require' => '请填写合同有效时间',
        'period.max'=>'合同有效时间最多只能填写3位数字',
        'protocol_id'=>'未上传协议合同',
    ];

    protected $scene = [
        'type1' => 'station_id,electric_type,electric_number,pay_number,multiple,init_degree,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel,room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period',
        'type2' => 'station_id,electric_type,electric_number,pay_number,multiple,init_degree,init_amount,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel,room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period',
        'type3' => 'station_id,electric_type,electric_number,multiple,init_degree,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel,room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period',
        'type4' => 'station_id,electric_type,electric_number,multiple,init_degree,init_amount,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel,room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period',
        'protocol' => 'protocol_id',
        'upType1' => 'electric_type,electric_number,pay_number,multiple,init_degree,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel,room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period',
        'upType2' => 'electric_type,electric_number,pay_number,multiple,init_degree,init_amount,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel,room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period',
        'upType3' => 'electric_type,electric_number,multiple,init_degree,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel,room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period',
        'upType4' => 'electric_type,electric_number,multiple,init_degree,init_amount,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel,room_position,property_position,receive,rent,engineroom_remark,contract_number,contract_confirm_date,period',
    ];
}