<?php
namespace app\station\controller\v1;
use app\station\model\BaseStationStatusModel;
use think\Controller;
/**
 * 基站状态API接口控制器
 * 负责基站状态的增删改查
 * Class Region
 * @package app\station\controller
 */
class BaseStationStatus extends Controller
{
    /**
 * 基站状态数据列表
 */
    public function baseStationStatus_list()
    {
    	  $model=new BaseStationStatusModel;
    	  $data=$model->selectBaseStationStatus_List();
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','Query error please try again');
          }
    	  
    }
/**
 * 添加基站状态
 */
      public function baseStationStatus_add()
    {
    	$parem=$this->request->post();
    	if($parem){
    	 $model=new BaseStationStatusModel;
    	 $result=$model->insertBaseStationStatus($parem);
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 修改基站状态
 */
     public function baseStationStatus_edit()
    {
    	 $parem=$this->request->post();
    	if($parem){
         if(empty($parem['cate_id'])){
            return jsonSucc('200001','参数不合法，无法修改');
         }
    	 $model=new BaseStationStatusModel;
    	 $result=$model->updBaseStationStatus($parem);
    	 if($result['code']==10001){
    	 	return jsonSucc('200001','id不存在');
    	 }
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 获取修改基站状态数据
 */
    public function geteditBaseStationStatus()
    {
    	$parem=$this->request->post();
    	 $model=new BaseStationStatusModel;
    	 $result=$model->updselectBaseStationStatus($parem);
    	  if($result['code']==10001){
    	  	return jsonSucc('200001','暂无找到id');
    	  }else{
    	  	 return jsonSucc('','suceess',$result['data']);
    	  }
    	 
    }
/**
 * 删除基站状态数据（软删除）
 */
     public function baseStationStatus_del()
    { 
      $parem=$this->request->post();
    	if($parem){
    	 $model=new BaseStationStatusModel;
    	 $result=$model->delBaseStationStatus($parem);
    	 switch ($result['code']) {
    	 	case '10001':
    	 		 return jsonSucc('200001','暂无找到id');
    	 		break;
    	 	
    	 	case '200':
    	 		 return jsonSucc('200','suceess');
    	 		break;

    	 	default:
    	 		return jsonSucc('1000001','error');
    	 		break;
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
}