<?php
namespace app\impexp\validate;
use app\admin\model\StaffModel;
use think\Validate;

/**
 * 抄表单字段数据校验
 * Class ImportCopyValidate
 * @package app\impexp\validate
 */
class ImportCopyValidate extends Validate
{
    public $staffs = [];

    protected $rule = [
        'A' => 'checkStaffName',
        'B' => 'require|number',
        'C' => 'require|number',
        'D' => 'date',
        'E' => 'number',
        //'F' => '',
        'G' => 'require|chs',
        'H' => 'require|number',
        'I' => 'require|float',
        'J' => 'require|float',
        'K' => 'require|float',
        'L' => 'number',
        'M' => 'float',
        //'N' => '',
        'O' => 'number',
        'P' => 'number',
        'Q' => 'chs',
        'R' => 'date',
        'S' => 'float',
        'T' => 'chs',
        'U' => 'chs',
        'V' => 'chs',
        'W' => 'float',
        'X' => 'date',
        'Y' => 'number',
        'Z' => 'chs',
        'AA' => 'chs',
        'AB' => 'float',
        'AC' => 'chs'
    ];

    protected $message = [
        'A.require' => '抄表员名字不存在',
        'A.chs' => '抄表员名字必须是汉字',
        'B.require' => '表号未填写',
        'B.number' => '表号只能是纯数字',
        'C.require' => '当前表数未填写',
        'C.number' => '当前表数只能是纯数字',
        'D.date' => '本次抄表日期只能填写数字',
        'E.number' => '本期余额只能填写数字',
        'G.require' => '电表类型未填写',
        'G.chs' => '电表类型只能填写汉字',
        'H.require' => '报移动电量未填写',
        'H.number' => '报移动电量只能是数字',
        'I.require' => '报移动单价未填写',
        'I.float' => '报移动单价只能是小数',
        'J.require' => '财务单价未填写',
        'J.float' => '财务单价只能是小数',
        'K.require' => '财务支出金额未填写',
        'K.float' => '财务支出金额只能是数字',
        'L.number' => '本次充值金额只能是数字',
        'M.float' => '电费余额只能是数字',
        'O.number' => '缴费单支票号只能是数字',
        'P.number' => '缴费发票号只能是数字',
        'Q.chs' => '缴费员名字是能是汉字',
        'R.date' => '缴费日期格式不正确',
        'S.float' => '税率只能填写数字',
        'T.chs' => '缴费方式只能填写汉字',
        'U.chs' => '发票类型只能填写汉字',
        'V.chs' => '结算客户只能填写汉字',
        'W.float' => '结算金额只能是数字',
        'X.date' => '结算日期格式不正确',
        'Y.number' => '结算发票号只能是数字',
        'Z.chs' => '结算人只能填写汉字',
        'AA.chs' => '结算状态只能填写汉字',
        'AB.float' => '税额只能是填写数字',
        'AC.chs' => '缴费情况只能填写汉字'
    ];

    protected function checkStaffName($value){
        dd($value);
        if(!empty($this->staffs)){
            return $this->staffs[$value] ? true : false;
        } else {
            $staffs = StaffModel::field('id,name')->select();
            $temp = [];
            foreach ($staffs as $k => $v){
                $temp[$v['name']] = $v['id'];
            }
            $this->staffs = $temp;
            return $this->staffs[$value] ? true : false;
        }
    }
}