<?php
namespace app\em\validate;
use think\Validate;

class EmAddBaseInfoValidate extends Validate
{
    protected $rule = [
        //base
        'station_id' => 'require',              //station_id,electric_type,electric_number,pay_number,multiple,init_degree,first_cp_date,unit_price,pay_cycle,staff_id,address,photo_id,contact,contact_tel
        'electric_type' => 'require',
        'qrcode' => 'require',
        'em_numb' =>'require',
        'pay_numb'=> 'require',
        'pricing_type' => 'require',
        'rate' => 'require|integer|max:10',
        'init_numb' => 'require',
        'init_amount' => 'require',
        'init_date' => 'require',
        'staff_id' => 'require',
        'photo_id' => 'require',

        //机房信息
        'dc_id' => 'require', //机房

        'contact' => 'require',
        'contact_tel' => 'require',
        'room_position'=>'require',
        'property_position'=>'require',
//        'receive' => 'require',
//        'rent' => 'require',
        'dc_remark' => 'max:255',



        'contract_numb' => 'require',
        'contract_confirm_date' => 'require',
        'period' => 'require|max:3',
        'protocol_id' => 'require'

    ];

    protected $message = [
        'station_id.require' => '没有选择基站',
        'em_type_id.require' => '请选择电表类型',
        'qrcode.require' => '请填写二维码',

        'em_numb.require' => '请填写电表识别号',
        'pay_numb.require' => '请填写缴费号',

        'rate.require' => '请填写倍率',
        'rate.integer' => '倍率只能填写正整数',
        'rate.max' => '倍率值不合法',
        'pricing_type.require' => '请选择计价方式',



        'init_numb.require' => '请填写初始读数',
        'init_amount.require' => '请填写初始读数',
        'init_date.require' => '请填写首次查表日期',
        'photo_id.require' => '请上传电表照片',
        'staff_id.require' => '请选择业务员',


        'charge_type.require' => '请填写计量模式',
        'pay_price.require' => '请填写缴费单价',
        'pay_cycle.require' => '请填写缴费周期',
        'pay_protocol_numb.require' => '请填写缴费协议编号',

        'cycle_start_time.require' => '请填写起始承包日期',
        'cycle_finish_time.require' => '请填写结束承包日期',
        'cycle_amount.require' => '请填写承包金额',
        'cycle_cert.require' => '请填写承包凭证编号',

        'settle_price.require' => '请填写结算单价',
        'settle_protocol_numb.require' => '请填写阶段协议编号',
        'settle_type.require' => '请选择结算模式',

        'dc_id.require' => '机房id信息错误', //机房
        'contact.require' => '请填写机房联系人',
        'contact_tel.require' => '请填写机房联系人',
        'room_position.require' => '请填写机房位置',
        'property_position.require' => '请填写物业位置',
        'receive.require' => '请填写实际收款单位',
        'rent.require' => '请填写出租单位信息',
        'dc_remark.max' => '机房备注信息不能超过80个汉字',


        'contract_numb.require' => '请填写合同编号',
    ];

    protected $scene = [
        //供电局普通表 需要缴费号 不需要初始余额
        's1' => 'station_id,em_type_id,em_numb,pay_numb,rate,pricing_type,init_numb,init_date,photo_id,staff_id,charge_type,
                    contact,contact_tel,room_position,property_position,receive,rent,dc_remark,
                    contract_numb',
        //供电局插卡表 需要缴费号 需要初始余额
        's2' => 'station_id,em_type_id,em_numb,pay_numb,rate,pricing_type,init_numb,init_amount,init_date,photo_id,staff_id,charge_type,contact,contact_tel,room_position,property_position,receive,rent,dc_remark,
                    contract_numb',
        //非供电局普通表 不需要缴费号 不需要初始余额
        's3' => 'station_id,em_type_id,em_numb,rate,pricing_type,init_numb,init_date,photo_id,staff_id,charge_type,
                    contact,contact_tel,room_position,property_position,receive,rent,dc_remark,
                    contract_numb',
        //非供电局插卡表 不需要缴费号 需要初始余额
        's4' => 'station_id,em_type_id,em_numb,rate,pricing_type,init_numb,init_amount,init_date,photo_id,staff_id,charge_type,
                    contact,contact_tel,room_position,property_position,receive,rent,dc_remark,
                    contract_numb'
    ];
}