<?php
namespace app\em\model;
use app\admin\model\DepartmentModel;
use app\admin\model\StaffModel;
use think\Session;

class Staff extends Base
{
    protected $table = 'staff';

    public function getStaffs($is_admin=false){
        if($is_admin){
            $staffs = StaffModel::field('id,name')->select()->toArray();
        } else {
            $user  =  \think\facade\Session::get('user');

            $staff = StaffModel::where('id','=',$user['user_id'])->find();
            $dIds = (new DepartmentModel)->getNodeIds($staff['d_id']);
            $staffs = StaffModel::field('id,name')->where('d_id','in',$dIds)->select()->toArray();
        }
        return $staffs;
    }
}