<?php

/**
 * v2 地图模块
 */
namespace app\em\controller;

use app\admin\controller\Base;
use app\admin\model\DepartmentModel;
use app\admin\model\ElectricMeter;
use app\admin\model\ElectricMeterType;
use app\admin\model\OperatorModel;
use app\admin\model\StaffModel;
use app\admin\model\BaseStationModel;

use think\Exception;
use think\facade\Request;
use think\facade\Session;

class Region extends Base
{


    public function region_list(){
        if (!Request::instance()->isAjax()){
            $this->assign('search_type','');
            $this->assign('search_text','');
            $this->assign('operator','');
            $this->assign('area_id','');
            $region=new ElectricMeter();
            $operator=new OperatorModel();
            $operators = OperatorModel::field('operator_id,operator_name')->where('operator_state','=',1)->select()->toArray();
            $this->assign('regions',getTree($region->regions()));
            $this->assign('operators',$operators);
            return $this->fetch();
        }else{
            $map=[];
            $aa= Request::param('type');
             if($aa==1){
                $data= Request::param('data');
                $search_text=$data['search_text'];
                $search_type=$data['search_type'];
        if($search_text){
            switch ($search_type) {
                case '1':
                    $this->assign('search_text',$search_text);
                    $map[]=['station_info.station_name','like',"%$search_text%"];
                    $this->assign('search_type',$search_type);
                    break;
                case '2':
                    $this->assign('search_text',$search_text);
                    $map[]=['station_info.station_sp_code','like',"%$search_text%"];
                    $this->assign('search_type',$search_type);
                    break;
                case '3':
                    $this->assign('search_text',$search_text);
                    $map[]=['station_info.proj_number','like',"%$search_text%"];
                    $this->assign('search_type',$search_type);
                    break;
              
            }
        }else{
            $this->assign('search_type','');
            $this->assign('search_text','');
        }
               
          
            $operator = $data['operator'];
            if($operator){
            $map[] = ['station_info.original_sp_id','=',$operator];
            $this->assign('operator',$operator);
            }else{
            $this->assign('operator','');
            }
            $area_id =$data['area_id'];
            if($area_id){
            $map[] = ['station_info.area_id','=',$area_id];
            $this->assign('area_id',$area_id);
            }else{
            $this->assign('area_id','');
            }
            if(!$map){
                 echo 0;die;
            }
            
                //权限检测
                $user = Session::get('user');
                if(!$user['is_admin']){
                $permissionData=check_data();
                if($permissionData){
                $map[]=$permissionData;
                }
                }
             $map[] = ['d.longitude','neq',""];
             $map[] = ['d.latitude','neq',""];
             $datalist= BaseStationModel::field('station_id,station_name,proj_number,longitude,latitude')->leftJoin(['station_info_detai'=>'d'],'station_info.station_id = d.stationid')->where($map)->limit(200)->select()->toArray();
             }else{
                $map1=[];
                //权限检测
                $user = Session::get('user');
                if(!$user['is_admin']){
                $permissionData=check_data();
                if($permissionData){
                $map1[]=$permissionData;
                }
                }
                $position= Request::param('data');
               
                $ff= $position['lng'];
                $ee= $position['lat'];
                $fff=$ff+"0.200000";
                $eee=$ee+"0.200000";
                $map1[] = ['d.longitude','between',"$ff,$fff"];
                $map1[] = ['d.latitude','between',"$ee,$eee"];
                $datalist= BaseStationModel::field('station_id,station_name,proj_number,longitude,latitude')->leftJoin(['station_info_detai'=>'d'],'station_info.station_id = d.stationid')->where($map1)->select()->toArray();
                  
             }
         
          if(!$datalist){
                    echo 0;die;
                }
             $lats = $lons = array();

                foreach ($datalist as $key => $value) {
                    array_push($lats, $value['latitude']);
                    array_push($lons, $value['longitude']);

                }

                $minlat = min($lats);
                $maxlat = max($lats);
                $minlon = min($lons);
                $maxlon = max($lons);

                $zpoint = [
                    'minLat'=>$minlat,
                    'maxLat'=>$maxlat,
                    'minLng'=>$minlon,
                    'maxLng'=>$maxlon
                ];
                $lat = $maxlat - (($maxlat - $minlat) / 2);
                $lng = $maxlon - (($maxlon - $minlon) / 2);
                $oPoint=array("latitude" => $lat, "longitude" => $lng);
                $datalist['datacount'] = 5000;
                $datalist['counts'] = 200;
                $datalist['oPoint'] = $oPoint;
                $datalist['zPoint'] = $zpoint;
                if($datalist){
                    echo json_encode($datalist);
                }
                
       }
    }


   
}