<?php
//配置所有接口功能
namespace app\api\controller\v1\supplier;

use app\api\controller\v1\common\Department;
use app\api\controller\v1\common\Role;
use app\api\controller\v1\common\Staff;
use app\api\controller\v1\common\BasicInfor;

use app\api\service\Provider;

class Assign
{
    protected $token ;

    public function __construct(){
        $this->token =  Provider::Container('token');
    }

    public function createToken(){
        return $this->token->create();
    }

    public function getCurrentStaff($id){
        $this->token->check();
        return (new Staff)->getCurrentStaff($id);
    }

    public function getStaffs(){
        $this->token->check();
        return (new Staff)->getStaffs();
    }

    public function getIdentities(){
        $this->token->check();
        return (new Staff)->getIdentities();
    }

    public function getDepartments(){
        $this->token->check();
        return (new Department)->getDepartments();
    }

    public function getDepartmentsWithLevel(){
        $this->token->check();
        return (new Department)->getDepartmentsWithLevel();
    }

    public function getRoles(){
        $this->token->check();
        return (new Role)->getRoles();
    }

    public function getRegions(){
        $this->token->check();
        return (new BasicInfor)->getRegions();
    }

    public function getBusiness(){
        $this->token->check();
        return (new BasicInfor)->getBusiness();
    }

    public function getOperator(){
        $this->token->check();
        return (new BasicInfor)->getOperator();
    }

    public function getSource(){
        $this->token->check();
        return (new BasicInfor)->getSource();
    }
    public function getCustomers(){
        $this->token->check();
        return (new BasicInfor)->getCustomers();
    }

    public function getBasestate(){
        $this->token->check();
        return (new BasicInfor)->getBasestate();
    }

}