<?php

/**
 * 基础信息接口
 */
namespace app\api\controller\v1\common;
use app\api\exception\DbLinkException;
use think\Db;

class BasicInfor
{

    //获取区域列表信息
    public function getRegions(){
         $regions = Db::table('region')
            ->field('id,region_name,region_state,pid,create_time')
            ->where('region_state','=',1)
            ->select();
        $regionsdata  =self::getRegionsTree($regions);
            
        if(!$regionsdata){
            throw new DbLinkException;
        }        
        return json([
            'code' => 200,
            'message' => 'SUCCESS',
            'data' => $regionsdata
        ]);
    }


       //获取业务线列表信息
    public function getBusiness(){
         $business = Db::table('business_line')
            ->field('business_id,business_name,business_state,create_time')
            ->where('business_state','=',1)
            ->select();
        if(!$business){
            throw new DbLinkException;
        }

        
        return json([
            'code' => 200,
            'message' => 'SUCCESS',
            'data' => $business
        ]);
    }
 

     ///获取运营商列表信息
    public function getOperator(){
         $operator = Db::table('operator')
            ->field('operator_id,operator_name,operator_state,pid,create_time')
            ->where('operator_state','=',1)
            ->select();
        $operators  =self::getOperatorTree($operator);
        if(!$operators){
            throw new DbLinkException;
        }

        
        return json([
            'code' => 200,
            'message' => 'SUCCESS',
            'data' => $operators
        ]);
    }

      ///获取需求来源列表信息
    public function getSource(){
         $source = Db::table('demand_source')
            ->field('sources_id,sources_name,sources_state,create_time')
            ->where('sources_state','=',1)
            ->select();
        if(!$source){
            throw new DbLinkException;
        }

        
        return json([
            'code' => 200,
            'message' => 'SUCCESS',
            'data' => $source
        ]);
    }


      ///获取上游客户列表信息
    public function getCustomers(){
         $customers = Db::table('upstream_customers')
            ->field('customers_id,customers_name,customers_state,create_time')
            ->where('customers_state','=',1)
            ->select();
        if(!$customers){
            throw new DbLinkException;
        }

        
        return json([
            'code' => 200,
            'message' => 'SUCCESS',
            'data' => $customers
        ]);
    }


       //获取基站状态列表信息
    public function getBasestate(){
         $basestate = Db::table('station_statuscate')
            ->field('cate_id,cate_name,pid,state,create_time')
            ->where('state','=',1)
            ->order("sort asc")
            ->select();
          $basestates  =self::getBasestateTree($basestate);
        if(!$basestate){
            throw new DbLinkException;
        }

        
        return json([
            'code' => 200,
            'message' => 'SUCCESS',
            'data' => $basestates
        ]);
    }
  

  static function getBasestateTree($array, $pid =0, $level = 0){
    //声明静态数组,避免递归调用时,多次声明导致数组覆盖
    static $list = [];
    foreach ($array as $key => $value){
        //第一次遍历,找到父节点为根节点的节点 也就是pid=0的节点
        if ($value['pid'] == $pid){
            //父节点为根节点的节点,级别为0，也就是第一级
            $value['level'] = $level;
            //把数组放到list中
            $list[] = $value;
            //把这个节点从数组中移除,减少后续递归消耗
            unset($array[$key]);
            //开始递归,查找父ID为该节点ID的节点,级别则为原级别+1
            self::getBasestateTree($array, $value['cate_id'], $level+1);
        }
    }
    return $list;
}

  static function getOperatorTree($array, $pid =0, $level = 0){
    //声明静态数组,避免递归调用时,多次声明导致数组覆盖
    static $list = [];
    foreach ($array as $key => $value){
        //第一次遍历,找到父节点为根节点的节点 也就是pid=0的节点
        if ($value['pid'] == $pid){
            //父节点为根节点的节点,级别为0，也就是第一级
            $value['level'] = $level;
            //把数组放到list中
            $list[] = $value;
            //把这个节点从数组中移除,减少后续递归消耗
            unset($array[$key]);
            //开始递归,查找父ID为该节点ID的节点,级别则为原级别+1
            self::getOperatorTree($array, $value['operator_id'], $level+1);
        }
    }
    return $list;
}

  static function getRegionsTree($array, $pid =0, $level = 0){
    //声明静态数组,避免递归调用时,多次声明导致数组覆盖
    static $list = [];
    foreach ($array as $key => $value){
        //第一次遍历,找到父节点为根节点的节点 也就是pid=0的节点
        if ($value['pid'] == $pid){
            //父节点为根节点的节点,级别为0，也就是第一级
            $value['level'] = $level;
            //把数组放到list中
            $list[] = $value;
            //把这个节点从数组中移除,减少后续递归消耗
            unset($array[$key]);
            //开始递归,查找父ID为该节点ID的节点,级别则为原级别+1
            self::getRegionsTree($array, $value['id'], $level+1);
        }
    }
    return $list;
}
}