<?php

namespace app\admin\validate;
use think\Validate;

class ContractAddProtocolValidate extends Validate
{
    protected $rule = [
        'name' => 'require',
        'number' => 'require',
        'start_date' => 'require',
        'end_date' => 'require',
        'sign_date' => 'require',
        'file_id' => 'require',
        'remark' => 'max:255'
    ];

    protected $message = [
        'name.require' => '请填写合同/协议名称',
        'number.require' => '请填写合同/协议编号',
        'start_date.require' => '请填写开始日期',
        'end_date.require' => '请填写结束日期',
        'sign_date.require' => '请填写签订日期',
        'file_id.require' => '未上传合同/协议文件',
        'remark.max' => '备注不能超过80个汉字'
    ];
}