<?php 

namespace app\admin\model;


class ReviewModel extends BaseModel{
	protected $table = 'review';

	public static function getMessage(){
	    $data = self::field('*')
                    ->field('staff.name as staffName')
                    ->field('dept.name as deptName')
                    ->leftJoin(['staff'],'staff.id = review.staff_id')
                    ->leftJoin(['department'=> 'dept'],'staff.d_id = dept.id')
                    ->order('review.create_time desc')
                    ->select()->toArray();
	    return $data;
    }

    public function getCreateTimeAttr($value){
	    return date('Y-m-d H:s:i',$value);
    }

}