<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2019-6-25
 * Time: 23:29
 */

namespace app\admin\controller;

//缴费单控制器
use app\admin\model\CopyModel;
use app\admin\model\InvoiceTypeModel;
use app\admin\model\OrderModel;
use app\admin\model\PaymentModel;
use app\admin\model\PayWayModel;
use app\admin\model\StaffModel;
use app\admin\model\TaxRateModel;
use app\admin\validate\PaymentAddValidate;
use think\facade\Request;

class Payment extends Base
{
    public function create($cp_id){
        //检测是否完成了缴费订单
        //基本信息
        $users = StaffModel::getCurrentStaffsByDepartment();
        $copy = CopyModel::getCopyEmInfoByCid($cp_id);

        //身份信息
        $identity = (new Staff)->getIdentity();
        $this->assign('iden',$identity);

        $payment = PaymentModel::with('photo')->where(['cp_id'=>$cp_id])->find();
        if($payment){
            if(isset($payment->photo)){
                $payment->photo_src = ltrim($payment->photo->src,'.');
            } else{
                $payment->photo_src = '';
            }
        } else {
            $payment = new PaymentModel();
            $payment->pay_way = '';
            $payment->photo_src = '';
            $payment->invoice_type = '';
            $payment->tax_rate = '';
            $payment->tax_amount = '';
            $payment->pay_sid = '';
            $payment->pay_date = date('Y-m-d');
        }

        //如果是修改则找到提交人
        if($payment->pay_sid > 1 ){
            $users = StaffModel::getStaffsByDepartment($payment->pay_sid);
        }


        $order = OrderModel::get(['cp_id'=>$cp_id]);
        $this->assign('order',$order);

        $this->assign('payment',$payment);

        $payways = PayWayModel::select()->toArray();
        $taxRates = TaxRateModel::select()->toArray();
        $invoiceType = InvoiceTypeModel::select()->toArray();

        $this->assign('invoice_type',$invoiceType);
        $this->assign('taxrates',$taxRates);
        $this->assign('payways',$payways);
        $this->assign('users',$users);
        $this->assign('copy',$copy);
        return $this->fetch('add');
    }

    public function upInvoice(){
        $file = Request::file('invoice_file');
        $upload = new Upload($file,1);
        $result = $upload->upload();

        if(!empty($result)){
            return jsonSuc('上传发票附件成功',$result);
        } else {
            return jsonErr($result);
        }
    }

    public function store(){
        $data = Request::post();

        $validate = new PaymentAddValidate();

        //如果是现金则不验证支票号
        if($data['pay_way'] == 3){
            if(!$validate->scene('cash')->check($data)){
                return jsonErr($validate->getError());
            }
        } else {
            if(!$validate->scene('checkNumb')->check($data)){
                return jsonErr($validate->getError());
            }
        }


        if(Request::post('payment_id')){
            $pay = PaymentModel::find(Request::post('payment_id'));
        } else {
            $pay = new PaymentModel();
        }

        $pay->cp_id = $data['cp_id'];
        $pay->pay_way = $data['pay_way'];
        $pay->check_numb = $data['check_numb'];
        $pay->pay_date = $data['pay_date'];
        $pay->invoice_numb = $data['invoice_numb'];
        $pay->invoice_fid = $data['invoice_fid'];
        $pay->invoice_type = $data['invoice_type'];
        $pay->tax_rate = $data['tax_rate'];
        $pay->tax_amount = $data['tax_amount'];
        $pay->pay_sid = $data['pay_sid'];

        if($pay->save()){
            //更新order状态
            $order = OrderModel::order('id desc')->get(['cp_id'=>$data['cp_id']]);
            $order->payment_id = $pay->id;
            if($order->save()){
                return jsonSuc('保存缴费信息成功');
            } else {
                return jsonErr('更新订单信息失败');
            }
        } else {
            return jsonErr('添加缴费信息错误,请联系管理员');
        }
     }
}