<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2019-6-25
 * Time: 23:28
 */

namespace app\admin\controller;

//流水管理控制器
use app\admin\model\OrderModel;
use app\admin\model\ReviewModel;
use app\admin\model\SettleModel;
use think\Exception;
use think\facade\Request;

class Order extends Base
{
    //生成订单号
    public static function serial($id='',$per=''){
        //前缀
        $per = $per ?: config('admin.order_per');

        if($id == '') {
            $order = OrderModel::order('id desc')->find();
            if($order){
                $id = $order->id + 1;
            } else {
                $id = 1;
            }
        }
        return $per.date('Ymd',time()).str_pad($id,5,'0',STR_PAD_LEFT);
    }

    //根据订单状态查询订单进度
    public function state($id){

        //根据订单ID查询订单状态
        $order = OrderModel::get($id);

        //如果没有订单生成，则是状态1
        $step1  = 1;
        if($order){
            $step2 = isset($order->statement_id) ? 2 : 0;
            $step3 = isset($order->payment_id) ? 3 : 0;
            $step4 = isset($order->settle_id) ? 4 : 0;
        }
        return $step1 + $step2 + $step3 + $step4;  // 1,3,6,7,10
    }


    public function check(){
        $type = Request::post('check');
        $cp_id = Request::post('cp_id');

        if($type == '' || $cp_id == ''){
            return jsonErr('数据错误');
        }
        $order = OrderModel::get(['cp_id'=>$cp_id]);

        switch ($type){
            case 'payment':
                $pay_id = Request::post('payment_id');

                if($order->payment_id == $pay_id){
                    $order->payment_status = 1;      //更改状态
                    $order->payment_time = time();   //确认时间
                    $order->payment_uid = (new Staff())->getCurrentUser()->id; //确认人
                    //查看是否已经审核结算信息
                    if($order->settle_status == 1){
                        $order->status = 1;
                    } else {
                        $order->status = 2;
                    }

                    if($order->save()){
                        //记录审核信息
                        $reivew = new ReviewModel;
                        $reivew->staff_id = (new Staff())->getCurrentUser()->id;
                        $reivew->cp_id = $cp_id;
                        $reivew->action = 1;
                        $reivew->result = 1;
                        $reivew->message = '员工: '.(new Staff())->getCurrentUser()->name .
                                           ' 在: '.$order->payment_time .
                                           '对流水单号是：'. $order->order_id .' 抄表单号是：' . $cp_id .' 进行了缴费确认!';
                        $reivew->save();

                        return jsonSuc('已审核缴费信息');
                    }
                }
                break;
            case 'settle':
                $settle_id = Request::post('settle_id');

                if($order->settle_id == $settle_id){
                    $order->settle_status = 1;     //更改状态
                    $order->settle_time = time();  //确认时间
                    $order->settle_uid =  (new Staff())->getCurrentUser()->id; //确认人

                    //查看是否已经审核缴费信息
                    if($order->payment_status == 1){
                        $order->status = 1;
                    } else {
                        $order->status = 3;
                    }
                    if($order->save()){

                        //更新settle
                        $settle = SettleModel::find($settle_id);
                        $settle->status = 1;
                        $settle->save();

                        $reivew = new ReviewModel;
                        $reivew->staff_id = (new Staff())->getCurrentUser()->id;
                        $reivew->cp_id = $cp_id;
                        $reivew->action = 2;
                        $reivew->result = 1;
                        $reivew->message = '员工: '.(new Staff())->getCurrentUser()->name .
                            ' 在: '.$order->settle_time.
                            '对流水单号是：'. $order->order_id .' 抄表单号是：' . $cp_id .' 进行了结算确认!';
                        $reivew->save();
                        return jsonSuc('已审核结算信息');
                    }
                } else {
                    return jsonErr('信息不匹配');
                }
                break;
        }
    }

    public function applyConfirm(){
        $id = Request::post('id');

        //则查找order
        if($id > 0){
            $order = OrderModel::find($id);
            if(!$order){
                return jsonSuc('参数错误,找不到记录');
            }

            $order->status = 4;
            $order->save();
            return jsonSuc('已经提交确收等待财务确认');
        }
        else
            return jsonSuc('非法的参数');
    }

    public function confirm(){
        $id = Request::post('id');
        if($id > 0){
            $order = OrderModel::find($id);
            if(!$order){
                return jsonSuc('参数错误,找不到记录');
            }

            $order->status = 5;
            $order->save();
            return jsonSuc('已确收');
        }
        else
            return jsonSuc('非法的参数');
    }
}






