<?php

namespace app\admin\controller;
use app\admin\model\ContractModel;
use app\admin\validate\ContractAddProtocolValidate as ProtoValidate;

class Contract extends Base
{
    public function store($data){

        $protoValidate = new ProtoValidate;
        if(!$protoValidate->check($data)){
            return ['message'=>$protoValidate->getError(),'data'=>0];
        }

        //$contract = new ContractModel($data);

        if($data['id']){
            $contract = ContractModel::find($data['id']);
        } else {
            $contract = new ContractModel;
        }


        $contract->name = $data['name'];
        $contract->number = $data['number'];
        $contract->u_id = $data['u_id'];
        $contract->start_time = $data['start_date'];
        $contract->end_time = $data['end_date'];
        $contract->sign_time = $data['sign_date'];
        $contract->d_id = $data['d_id'];
        $contract->type = $data['type'];
        $contract->file_id = $data['file_id'];
        $contract->remark = $data['remark'];
        $contract->period = $data['period'];
        $message = $contract->type == 1 ? '添加合同成功' : '添加协议成功';
        $error = $contract->type == 1 ? '添加合同失败' : '添加协议失败';
        if($contract->save()){
            return ['message'=>$message,'data'=>$contract->id];
        } else {
            return ['message'=>$error,'data'=>0];
        }
    }
}