<?php 
namespace app\station\model;
use think\Model;
use think\model\concern\SoftDelete;
class BusinessModel extends Model
{
    use SoftDelete;
    protected static $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;
    //主键id
    protected $pk = 'business_id';
    //数据表
    protected $table = 'business_line';

    public  function selectBusinessList(){
     $data = $this->field("business_id,business_name,business_state")->select()->toarray();
            if($data){
                 return ['code' =>200,'message' => '查询成功' ,'data' => $data];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
    }
    public function insertBusiness($parem){
        try {
            $result=$this->allowField(true)->save($parem);
            if($result){
                 return ['code' =>200,'message' => '添加成功'];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
        } catch (Exception $e) {
               return ['code' => 0, 'message' => $e->getMessage()];
        }
     }

    public function updBusiness($parem){
        try {
            $result=$this->allowField(true)->save($parem,['business_id' => $parem['business_id']]);
            if($result){
                 return ['code' => 200, 'data' => '', 'message' => '修改成功'];
            }else{
                 return ['code' => -1, 'data' => '', 'message' => $this->getError()];
            }
        } catch (Exception $e) {
             return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
        }
     }
      public  function updselectBusiness($parem){
         $data = $this->field("business_id,business_name,business_state")->where($parem)->find();
              if($data){
                 return ['code' =>200,'message' => '查询成功' ,'data' => $data];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
        }


    public function delBusiness($parem){
          try {
            $data=$this->allowField(true)->where($parem)->find();
            if($data){
                $result=$this->destroy($parem);
                if($result){
                return ['code' => 200, 'data' => '', 'message' => '删除成功'];
                }else{
                return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
            }else{
               return ['code' => 10001, 'data' => '', 'message' => $this->getError()];
            }
          
            } catch (Exception $e) {
                 return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
            }
        }
}