<?php
namespace app\admin\validate;
use think\Validate;

class StaffValidate extends Validate
{
    protected $rule = [
        'name' => 'require',
        'email'=> 'require|email|unique:staff',
        'tel' => 'require|mobile',
    ];

    protected $message = [
        'name.require' => '名字必填',
        'email.require' => '请填写邮箱',
        'email.email' => '邮箱格式不正确',
        'email.unique' => '邮箱已存在',
        'tel.require' => '手机必填',
        'tel.mobile' => '手机号不正确'
    ];
}