<?php

namespace app\admin\validate;

use think\Validate;

class PermissionValidate extends Validate
{
    protected $rule =   [
        'pid'  => 'require|number|max:3',
        'title'=>'require|max:32',
        'model_name'=>'require|max:32',
        'controller_name'=>'require|max:32',
        'method_name'=>'require|max:32',
        'params'=>'max:200',
        'status'=>'in:0,1',
        'is_nav'=>'in:0,1'
    ];

    protected $message  =   [
        'pid.require' => '必须选择上级',
        'pid.number' => '上级分类id必须是数字',
        'pid.max' => '上级分类数值错误',

        'title.require'=>'权限名不能为空',
        'title.max'=>'权限名称不能超过32个字符或10个汉字',

        'model_name.require'=>'模块不能为空',
        'model_name.max'=>'模块标识不能超过32个字符',

        'controller_name.require'=>'控制器不能为空',
        'controller_name.max'=>'控制器标识不能超过32个字符',

        'method_name.require'=>'方法不能为空',
        'method_name.max'=>'方法标识不能超过32个字符',

        'params.max'=>'属性不能超过200个字符',
        'status.in'=>'状态只能是1或0',
        'is_nav.in'=>'导航只能是1或0'
    ];
}