<?php
namespace app\admin\validate;

use think\Validate;

class CopyAddValidate extends Validate
{
    protected $rule = [
        'em_id' => 'require',
        'before_number' => 'require',
        'before_time' => 'require|date',
        'current_number' => 'require|gt:before_number',
        'current_time' => 'require|date|gt:before_time',
        'current_amount' => 'require',
        'photo_id' => 'require',
        'staff_id' => 'require',
    ];

    protected $message = [
        'em_id.require' => '系统异常,电表id不存在请重新选择电表,请联系管理员',
        'before_number.require' => '系统异常,上期电表读数不正确,请联系管理员',
        'before_number.number' => '系统异常,上期电表度数不正确,必须是数字,请联系管理员',
        'before_time.require' => '系统异常,上期时期不正确,请联系管理员',
        'before_time.date' => '系统异常,上期日期不正确,非日期格式,请联系管理',
        'current_number.require' => '请填写本期抄表读数',
        'current_number.number' => '抄表读数只能是数字',
        'current_number.gt' => '本期读数必须大于上期读数',

        'current_time.require' => '请勾选本期抄表日期',
        'current_time.date' => '本期抄表日期必须为日期格式例:2019-06-30',
        'current_time.gt' => '本期抄表日期必须大于上期',

        'photo_id.require' => '请上传电表水印照片',
        'staff_id.require' => '系统异常,抄表员ID错误,请联系管理员',

        'current_amount.require' =>'请填写本期电表余额',
    ];

    protected $scene = [
        'postpaid' => 'em_id,current_number,current_time,photo_id,staff_id', //后付费表 普通标
        'prepaid' => 'em_id,current_number,current_time,photo_id,staff_id,current_amount',  //预付费表 插卡表
    ];
}