<?php

namespace app\admin\validate;


use think\Validate;

class AdminValidate extends Validate
{
    protected $rule =   [
        'name'  => 'require|max:32|unique:admin',
        'password'=>'require|confirm',
        'password_confirm'=>'require',
    ];

    protected $message  =   [
        'name.require' => '名称必须',
        'name.unique' => '用户名已存在',
        'name.max'     => '名称最多不能超过32个字符',
        'password.require'=>'密码必填',
        'password.confirm'   => '两次密码不一致',
        'password_confirm.require'=>'确认密码必填',
    ];

    protected $scene = [
        'create' => ['name','password','password_confirm'],
        'update' => ['password','password_confirm']
    ];
}